/*
    SPDX-FileCopyrightText: 2025 Yukari Chiba <i@0x7f.cc>

    SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once

#include "session.h"
#include <QMap>

// Forward declarations to avoid including headers here
struct libseat;
class QSocketNotifier;

namespace KWin
{

class SeatdSession : public Session
{
    Q_OBJECT

public:
    static std::unique_ptr<SeatdSession> create();
    ~SeatdSession() override;

    // Session interface
    bool isActive() const override;
    Capabilities capabilities() const override;
    QString seat() const override;
    uint terminal() const override;
    std::expected<int, Session::Error> openRestricted(const QString &fileName) override;
    void closeRestricted(int fileDescriptor) override;
    void switchTo(uint terminal) override;
    FileDescriptor delaySleep(const QString &reason) override;

private Q_SLOTS:
    void handleSeatdEvents();

private:
    explicit SeatdSession(struct libseat *seat);
    bool initialize();

    // libseat callbacks
    void handleEnableSeat();
    void handleDisableSeat();

    static void on_enable_seat(struct libseat *seat, void *userdata);
    static void on_disable_seat(struct libseat *seat, void *userdata);

    struct libseat *m_seat = nullptr;
    QSocketNotifier *m_notifier = nullptr;
    bool m_isActive = false;

    QMap<int, int> m_fileDescriptors;
};

} // namespace KWin
